package net.minecraft.src;

import java.io.File;
import java.awt.image.BufferedImage;
import java.io.IOException;
import javax.imageio.ImageIO;
import java.io.PrintStream;
import java.util.*;
import java.awt.Color;
import net.minecraft.src.forge.*;

public class WandImageImportStandard
{

    public WandImageImportStandard(EntityPlayer ientityplayer, World world, int i, int j, int k, int xend, int yend, BufferedImage ibufferedimage, int ixOrient, int iyOrient)
    {
		importfinished = false;
        entityplayer = ientityplayer;
        bufferedimage = ibufferedimage;
        xOrient = ixOrient;
        yOrient = iyOrient;
        worldObj = world;
        xCurrent = 0;
        yCurrent = 0;
        originX = i;
        originY = j;
        originZ = k;
		imageHeight = bufferedimage.getHeight();
        imageWidth = bufferedimage.getWidth();
        // if(xend < imageWidth)
        // {
        // 	imageHeight = xend;
        // }
        // if(yend < imageHeight)
        // {
        // 	imageHeight = yend;
        // }

		xxa = 0;
        xya = 0;
        xza = 0;
        yxa = 0;
        yya = 0;
        yza = 0;

		switch(xOrient)
        {
            case 1:
		xya = 1;
                break;
            case 2:
		xya = -1;
                break;
            case 3:
		xxa = -1;
                break;
            case 4:
		xxa = 1;
                break;
            case 5:
		xza = -1;
                break;
            case 6:
		xza = 1;
                break;
	    default:
                xxa = 1;
                break;
		}

		switch(yOrient)
        {
            case 1:
		yya = 1;
                break;
            case 2:
		yya = -1;
                break;
            case 3:
		yxa = -1;
                break;
            case 4:
		yxa = 1;
                break;
            case 5:
		yza = -1;
                break;
            case 6:
		yza = 1;
                break;
	    default:
                yza = 1;
                break;
		}

        //System.out.print((new StringBuilder()).append("Width: ").append(imageWidth).append("\n").toString());
        //System.out.print((new StringBuilder()).append("Height: ").append(imageHeight).append("\n").toString());
    }

    public void imageTick()
    {
        if(worldObj == null)
        {
           worldObj = mod_ColoredBlocks.mcInst.theWorld;
        }
        Random random = new Random();
        int xOffset = 0;
        int yOffset = 0;
        int zOffset = 0;
        int aRGB = bufferedimage.getRGB(xCurrent, yCurrent);
		Color pix = new Color(aRGB, true);
		int pixR = pix.getRed();
		int pixG = pix.getGreen();
		int pixB = pix.getBlue();

		if(xxa != 0)
        {
	    xOffset = xCurrent * xxa;
        }else
        if(xya != 0)
        {
            yOffset = xCurrent * xya;
        }else
        if(xza != 0)
        {
            zOffset = xCurrent * xza;
        }

		if(yza != 0)
        {
            zOffset = yCurrent * yza;
        }else
        if(yxa != 0)
        {
            xOffset = yCurrent * yxa;
        }else
        if(yya != 0)
        {
            yOffset = yCurrent * yya;
        }

		int newX = originX + xOffset;
		int newY = originY + yOffset;
		int newZ = originZ + zOffset;
		
		if(newY < 1 || newY > 127)
        {
            xCurrent += 1;

            if(xCurrent == imageWidth)
            {
                xCurrent = 0;
                yCurrent += 1;
                if(yCurrent == imageHeight)
                {
                    yCurrent = 0;
                    importfinished = true;
                }
            }
            return;
        }
	
		int newid = mod_ColoredBlocks.coloredblockid;
		int blockID = worldObj.getBlockId(newX, newY, newZ);
		int meta = worldObj.getBlockMetadata(newX, newY, newZ);
		if( worldObj.getBlockTileEntity(newX, newY, newZ) == null && blockID != 0 && blockID != newid && Block.blocksList[blockID] != null && Block.blocksList[blockID].isOpaqueCube()) 
		{
			worldObj.setBlockAndMetadata(newX, newY, newZ, newid, meta);
			TileEntityBlockColored tile = (TileEntityBlockColored)worldObj.getBlockTileEntity(newX, newY, newZ);
	        if(tile != null)
	        {
	            tile.setBlock(blockID, worldObj, newX, newY, newZ, meta);
				tile.setRed(pixR);
				tile.setGreen(pixG);
				tile.setBlue(pixB);
	            worldObj.markBlockNeedsUpdate(newX, newY, newZ);
	            for(int ll = 0; ll<5+random.nextInt(5);ll++)
	            {
	            	mod_ColoredBlocks.mcInst.effectRenderer.addEffect(new EntitySpellParticleColorFX(worldObj, newX+random.nextFloat(), newY+random.nextFloat(), newZ+random.nextFloat(), random.nextFloat(), random.nextFloat(), random.nextFloat(), pixR, pixG, pixB));
	            }
	        }
		}
		else
		if(blockID == newid)
		{
			TileEntityBlockColored tile = (TileEntityBlockColored)worldObj.getBlockTileEntity(newX, newY, newZ);
			if(tile != null)
			{
				tile.setRed(pixR);
				tile.setGreen(pixG);
				tile.setBlue(pixB);
				worldObj.markBlockNeedsUpdate(newX, newY, newZ);
	            for(int ll = 0; ll<5+random.nextInt(5);ll++)
	            {
	            	mod_ColoredBlocks.mcInst.effectRenderer.addEffect(new EntitySpellParticleColorFX(worldObj, newX+random.nextFloat(), newY+random.nextFloat(), newZ+random.nextFloat(), random.nextFloat(), random.nextFloat(), random.nextFloat(), pixR, pixG, pixB));
	            }
			}
		}

		xCurrent += 1;

		if(xCurrent == imageWidth)
        {
            xCurrent = 0;
            yCurrent += 1;
            if(yCurrent == imageHeight)
            {
				yCurrent = 0;
                importfinished = true;
			}
        }
            
    }

    public boolean importfinished;
    private EntityPlayer entityplayer;
    private BufferedImage bufferedimage;
    private World worldObj;
    private int xOrient;
    private int yOrient;
    private int xCurrent;
    private int yCurrent;
    private int originX;
    private int originY;
    private int originZ;
    private int imageWidth;
    private int imageHeight;
    private int xxa;
    private int xya;
    private int xza;
    private int yxa;
    private int yya;
    private int yza;
}